<?php
include 'config.php';

try {


    // Fetch product names from the database
    $stmt = $pdo->query("SELECT products_name FROM products where  is_product = 'product' and status= 1");
    $products = $stmt->fetchAll();

    // Start building the XML content
    $xmlContent = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
    $xmlContent .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . PHP_EOL;

    // Loop through each product and create a URL entry
    foreach ($products as $product) {
        // Clean up the product name for use in the URL
        $product_slug = createURL($product['products_name']);
        $url = $websiteUrl . '/products.php?products_title=' . $product_slug;

        $xmlContent .= '  <url>' . PHP_EOL;
        $xmlContent .= '    <loc>' . htmlspecialchars($url) . '</loc>' . PHP_EOL;
        $xmlContent .= '    <changefreq>weekly</changefreq>' . PHP_EOL;
        $xmlContent .= '    <priority>0.8</priority>' . PHP_EOL;
        $xmlContent .= '  </url>' . PHP_EOL;
    }

    //dynamic pages

    $stmt = $pdo->query("SELECT * FROM pages where status= 1");
    $pages = $stmt->fetchAll();

    foreach ($pages as $page) {
        $page_slug = createURL($page['page_link']);
        $url = $websiteUrl . '/pages.php?page_title=' . $page_slug;

        // if($page['page_type']==1){
        //     $url = $websiteUrl;
        // }
        // // if($page['page_type']==3){
        // //     $url = $websiteUrl."/storefinder";
        // // }
        // if($page['page_type']==4){
        //     $url = $websiteUrl."/about-us";
        // } 

        $xmlContent .= '  <url>' . PHP_EOL;
        $xmlContent .= '    <loc>' . htmlspecialchars($url) . '</loc>' . PHP_EOL;
        $xmlContent .= '    <changefreq>weekly</changefreq>' . PHP_EOL;
        $xmlContent .= '    <priority>0.8</priority>' . PHP_EOL;
        $xmlContent .= '  </url>' . PHP_EOL;
    }

    $xmlContent .= '</urlset>';

    // Save the sitemap as an XML file
    $sitemapFile = 'sitemap.xml'; // File path (can be adjusted to a directory)
    file_put_contents($sitemapFile, $xmlContent);

    // Display the sitemap in the browser
    // header('Content-Type: application/xml');
    // echo $xmlContent;


    // Create content for the robot.text file


    // Disallow: /public/
    // Sitemap: https://pandaepos.com/sitemap.xml
    $content = "User-agent:* \n";
    $content .= "Disallow: \n";
    $content .= "Disallow: /owners/\n";

    $content .= "Sitemap: $websiteUrl/sitemap.xml\n";

    // Define the file path and name
    $file = 'robot.txt';

    // Write content to the file
    file_put_contents($file, $content);
} catch (Exception $e) {
    echo 'Exception: ',  $e->getMessage(), "\n";
}
